/*
 * Decompiled with CFR 0.152.
 */
package io.neox.neonium;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class VeryEarlyModDetector {
    private static final String[] LITTLETILES_CLASS_MARKERS = new String[]{"com.creativemd.littletiles.LittleTiles", "com.creativemd.littletiles.LittleTilesTransformer", "com.creativemd.littletiles.LittlePatchingLoader"};
    private static final String[] SGCRAFT_CLASS_MARKERS = new String[]{"gcewing.sg.SGCraft", "gcewing.sg.SGCraftClient"};
    private static Boolean cachedLittleTilesResult = null;
    private static Boolean cachedSGCraftResult = null;

    public static boolean isLittleTilesPresent() {
        if (cachedLittleTilesResult != null) {
            return cachedLittleTilesResult;
        }
        try {
            boolean result = VeryEarlyModDetector.scanModsForLittleTiles();
            cachedLittleTilesResult = result;
            return result;
        }
        catch (Throwable t) {
            System.err.println("[Neonium] Error detecting LittleTiles: " + t.getMessage());
            return false;
        }
    }

    public static boolean isSGCraftPresent() {
        if (cachedSGCraftResult != null) {
            return cachedSGCraftResult;
        }
        try {
            boolean result = VeryEarlyModDetector.scanModsForSGCraft();
            cachedSGCraftResult = result;
            return result;
        }
        catch (Throwable t) {
            System.err.println("[Neonium] Error detecting SGCraft: " + t.getMessage());
            return false;
        }
    }

    private static boolean scanModsForLittleTiles() {
        try {
            File modsDir = new File("mods");
            if (!(modsDir.exists() && modsDir.isDirectory() || (modsDir = new File(".", "mods")).exists() && modsDir.isDirectory() || (modsDir = new File("..", "mods")).exists() && modsDir.isDirectory())) {
                return false;
            }
            File[] files = modsDir.listFiles();
            if (files == null) {
                return false;
            }
            for (File file : files) {
                boolean found;
                if (!file.isFile() || !file.getName().toLowerCase().endsWith(".jar") || !(found = VeryEarlyModDetector.scanJarForLittleTiles(file))) continue;
                System.out.println("[io.neox.neonium.VeryEarlyModDetector:scanModsForLittleTiles:90]: [Neonium] LittleTiles detected in JAR file: " + file.getName());
                return true;
            }
            return false;
        }
        catch (Throwable t) {
            System.err.println("[Neonium] Error scanning mods directory for LittleTiles: " + t.getMessage());
            return false;
        }
    }

    private static boolean scanModsForSGCraft() {
        try {
            File modsDir = new File("mods");
            if (!(modsDir.exists() && modsDir.isDirectory() || (modsDir = new File(".", "mods")).exists() && modsDir.isDirectory() || (modsDir = new File("..", "mods")).exists() && modsDir.isDirectory())) {
                return false;
            }
            File[] files = modsDir.listFiles();
            if (files == null) {
                return false;
            }
            for (File file : files) {
                boolean found;
                if (!file.isFile() || !file.getName().toLowerCase().endsWith(".jar") || !(found = VeryEarlyModDetector.scanJarForSGCraft(file))) continue;
                System.out.println("[Neonium] SGCraft detected in JAR file: " + file.getName());
                return true;
            }
            return false;
        }
        catch (Throwable t) {
            System.err.println("[Neonium] Error scanning mods directory for SGCraft: " + t.getMessage());
            return false;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static boolean scanJarForLittleTiles(File file) {
        try (JarFile jarFile = new JarFile(file);){
            JarEntry mcmodInfo = jarFile.getJarEntry("mcmod.info");
            if (mcmodInfo != null) {
                try (InputStream is = jarFile.getInputStream(mcmodInfo);){
                    String mcmodContent = VeryEarlyModDetector.readStream(is);
                    if (mcmodContent.contains("\"modid\": \"littletiles\"") || mcmodContent.contains("\"modid\":\"littletiles\"")) {
                        boolean bl = true;
                        return bl;
                    }
                }
            }
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                String entryName;
                JarEntry entry = entries.nextElement();
                if (entry.isDirectory() || !(entryName = entry.getName()).endsWith(".class")) continue;
                String className = entryName.replace('/', '.').replace(".class", "");
                for (String marker : LITTLETILES_CLASS_MARKERS) {
                    if (!className.equals(marker)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static boolean scanJarForSGCraft(File file) {
        try (JarFile jarFile = new JarFile(file);){
            JarEntry mcmodInfo = jarFile.getJarEntry("mcmod.info");
            if (mcmodInfo != null) {
                try (InputStream is = jarFile.getInputStream(mcmodInfo);){
                    String mcmodContent = VeryEarlyModDetector.readStream(is);
                    if (mcmodContent.contains("\"modid\": \"sgcraft\"") || mcmodContent.contains("\"modid\":\"sgcraft\"")) {
                        boolean bl = true;
                        return bl;
                    }
                }
            }
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                String entryName;
                JarEntry entry = entries.nextElement();
                if (entry.isDirectory() || !(entryName = entry.getName()).endsWith(".class")) continue;
                String className = entryName.replace('/', '.').replace(".class", "");
                for (String marker : SGCRAFT_CLASS_MARKERS) {
                    if (!className.equals(marker)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    private static String readStream(InputStream input) throws IOException {
        StringBuilder content = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(input));){
            String line;
            while ((line = reader.readLine()) != null) {
                content.append(line);
            }
        }
        return content.toString();
    }

    static {
        VeryEarlyModDetector.LITTLETILES_CLASS_MARKERS[0] = "com.creativemd.littletiles.LittleTiles";
        VeryEarlyModDetector.LITTLETILES_CLASS_MARKERS[1] = "com.creativemd.littletiles.LittleTilesTransformer";
        VeryEarlyModDetector.LITTLETILES_CLASS_MARKERS[2] = "com.creativemd.littletiles.LittlePatchingLoader";
        VeryEarlyModDetector.SGCRAFT_CLASS_MARKERS[0] = "gcewing.sg.SGCraft";
        VeryEarlyModDetector.SGCRAFT_CLASS_MARKERS[1] = "gcewing.sg.SGCraftClient";
    }
}

